## TikTok 后台自动查询与回写（Chrome Extension / MV3）

该扩展实现无人值守闭环：**系统端 pull（拉取即锁定） → TikTok 后台搜索查询 → 解析账号状态 → 系统端 report 回写 → 下一批**。

- **不依赖 popup 常驻**：由 `service_worker.js` + `chrome.alarms` 驱动。
- **风控保护**：遇到 `need_login/rate_limited` 连续触发会全局 cooldown；遇到 `page_changed` 直接熔断暂停。
- **可观测**：Popup 展示运行状态、批次进度、统计与最近日志（可复制）。

---

## 1) 安装（加载已解压）

1. 打开 `chrome://extensions/`，开启「开发者模式」
2. 点击「加载已解压的扩展程序」
3. 选择目录：`tk-sync-ext/`

---

## 2) 配置（Options）

打开扩展的 Options 页面，填写：

- **System Base URL**：例如 `https://your-domain.com`
- **Token（Bearer）**：服务端启用 `TK_SYNC_TOKEN` 时必填（否则可留空）
- **Region**：默认 `latam`
- **Pull Limit / Lock Minutes / Tick Interval / Jitter**：按需调整
- 点击 **「授权 SYSTEM_BASE 域名」**：用于动态申请 `host_permissions`（因为 manifest 无法预知你配置的系统端域名）

> 重要：Chrome MV3 规定 `chrome.permissions.request()` 必须由“用户手势（点击）”触发。
> 因此扩展不会在后台无人值守循环中自动弹权限框；若未授权会进入暂停态并提示你在 Options 授权，授权后会自动恢复运行。

---

## 3) 运行

1. 在浏览器中打开并登录 TikTok 后台（默认匹配：`https://live-backstage.tiktok.com/*`）
2. 打开扩展 Popup，点击 **Start**
3. 扩展将持续循环处理，直到系统端无可用数据

---

## 4) Manifest 注意事项（TikTok 后台域名/路径）

`manifest.json` 默认只匹配：

- `host_permissions`: `https://live-backstage.tiktok.com/*`
- `content_scripts.matches`: `https://live-backstage.tiktok.com/*`

如果你实际使用的是其他 TikTok 后台域名/路径（例如不同的 Admin Host），需要同步修改这两处 pattern，否则 `content_script.js` 无法注入。

---

## 5) 常见故障排查

- **一直报 need_login**：TikTok 后台登录态失效；请在目标 tab 重新登录。
- **频繁出现 rate_limited / 验证码**：扩展会自动 cooldown，请等待倒计时结束；必要时降低处理速度（增大 jitter、增大 tickSeconds、减小 pullLimit）。
- **出现 page_changed**：页面结构变化导致选择器/判定失效；扩展会熔断暂停，避免刷接口。需要更新 `content_script.js` 的选择器/判定逻辑。
- **pull/report 失败**：
  - 检查 Options 中 `System Base URL` 是否正确
  - 点击「授权 SYSTEM_BASE 域名」授予 host 权限
  - 检查服务端是否启用了 `TK_SYNC_TOKEN`，以及 token 是否匹配
