async function send(msg) {
  return await chrome.runtime.sendMessage(msg);
}

function $(id) {
  return document.getElementById(id);
}

function setStatus(text, kind) {
  const el = $('status');
  el.textContent = text;
  el.className = 'hint ' + (kind || '');
}

function originPattern(url) {
  const u = new URL(url);
  return u.origin + '/*';
}

async function load() {
  const res = await send({ type: 'TK_SYNC_GET_STATE' });
  if (!res || !res.ok) return;
  const s = res.settings || {};

  $('systemBase').value = s.systemBase || 'https://tkradar.com/';
  $('token').value = s.token || '';
  $('region').value = s.region || '*';
  $('pullLimit').value = s.pullLimit ?? 0;
  $('lockMinutes').value = s.lockMinutes ?? 10;
  $('tickSeconds').value = s.tickSeconds ?? 60;
  $('jitterMinSec').value = s.jitterMinSec ?? 3;
  $('jitterMaxSec').value = s.jitterMaxSec ?? 8;
  $('consecutiveRiskThreshold').value = s.consecutiveRiskThreshold ?? 5;
  $('cooldownMinutes').value = s.cooldownMinutes ?? 30;
  $('tiktokAdminUrl').value = s.tiktokAdminUrl || 'https://live-backstage.tiktok.com/portal/overview';
}

async function save() {
  const pullLimitRaw = String($('pullLimit').value ?? '').trim();
  const patch = {
    systemBase: $('systemBase').value.trim(),
    token: $('token').value.trim(),
    region: $('region').value.trim() || '*',
    // 允许 0（表示不限量）
    pullLimit: pullLimitRaw === '' ? 0 : Number(pullLimitRaw),
    lockMinutes: Number($('lockMinutes').value || 10),
    tickSeconds: Number($('tickSeconds').value || 60),
    jitterMinSec: Number($('jitterMinSec').value || 3),
    jitterMaxSec: Number($('jitterMaxSec').value || 8),
    consecutiveRiskThreshold: Number($('consecutiveRiskThreshold').value || 5),
    cooldownMinutes: Number($('cooldownMinutes').value || 30),
    tiktokAdminUrl: $('tiktokAdminUrl').value.trim() || 'https://live-backstage.tiktok.com/portal/overview'
  };

  if (!patch.systemBase) {
    setStatus('请填写 System Base URL', 'err');
    return;
  }

  try {
    new URL(patch.systemBase);
  } catch {
    setStatus('System Base URL 格式不合法', 'err');
    return;
  }

  await send({ type: 'TK_SYNC_SET_SETTINGS', patch });
  setStatus('已保存', 'ok');
}

async function grant() {
  const base = $('systemBase').value.trim();
  if (!base) {
    setStatus('请先填写 System Base URL', 'err');
    return;
  }
  let pattern;
  try {
    pattern = originPattern(base);
  } catch {
    setStatus('System Base URL 格式不合法', 'err');
    return;
  }

  const granted = await chrome.permissions.request({ origins: [pattern] });
  if (granted) setStatus('已授权', 'ok');
  else setStatus('用户拒绝授权（将导致无法访问系统端 API）', 'err');
}

$('saveBtn').addEventListener('click', () => save().catch(e => setStatus(String(e), 'err')));
$('grantBtn').addEventListener('click', () => grant().catch(e => setStatus(String(e), 'err')));

load();
